<?php

namespace IZON\DBLocale\Interceptor;

use IZON\DBLocale\Dao\DBCountryDao;
use IZON\DBLocale\Dao\DBCurrencyDao;
use IZON\DBLocale\Dao\DBLanguageDao;
use IZON\DBLocale\Dao\DBLocaleDao;
use IZON\DBLocale\Domain\DBLocale;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * @deprecated do not use, use $request->getLocale() in controller/interceptor or getLocale() in view
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class LocaleInterceptor implements Interceptor
{
    /**
     * Pod jaky nazvem je informace o locale dostupny
     */
    public const AVAILABLE_AS = '_locale';

    protected DBCountryDao $countryDao;

    protected DBCurrencyDao $currencyDao;

    protected DBLanguageDao $languageDao;

    protected DBLocaleDao $localeDao;

    public function __construct(
        DBCountryDao $countryDao,
        DBCurrencyDao $currencyDao,
        DBLanguageDao $languageDao,
        DBLocaleDao $localeDao
    ) {
        $this->countryDao = $countryDao;
        $this->currencyDao = $currencyDao;
        $this->languageDao = $languageDao;
        $this->localeDao = $localeDao;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) // @phpstan-ignore missingType.return
    {
        $model->putParameter(self::AVAILABLE_AS, $request->getParameter(self::AVAILABLE_AS));
    }

    public function preHandle(HttpRequest $request)
    {
        $locale = $request->getLocale();

        /** @var DBLocale $dbLocale */
        $dbLocale = $this->localeDao
            ->find(['localeTag' => $locale->toLocaleTag()])->uniqueResult();
        $dbLocale->setCountry($this->countryDao->load($dbLocale->getFkCountryId()));
        $dbLocale->setCurrency($this->currencyDao->load($dbLocale->getFkCurrencyId()));
        $dbLocale->setLanguage($this->languageDao->load($dbLocale->getFkLanguageId()));

        $request->setSessionParameter(self::AVAILABLE_AS, $dbLocale);
        $request->addParameter(self::AVAILABLE_AS, $dbLocale);

        return null;
    }
}
