<?php

namespace IZON\DBLocale\Domain;

use IZON\DB\Definitions\AbstractDefinition;
use IZON\Utils\Locale as UtilsLocale;
use function IZON\DB\transientField;

/**
 * Description of Locale
 * @author Vítězslav Jahn, IZON s.r.o. <jahn@izon.cz>
 */
class DBLocale extends Locale // @phpstan-ignore class.extendsDeprecatedClass
{
    protected ?int $id = null;

    /**
     * @var string jak je otagovano locale podle RFC http://php.net/manual/en/class.locale.php
     */
    protected string $localeTag;

    protected int $fkCountryId;

    /**
     * @var DBCountry
     */
    protected $country;

    protected int $fkLanguageId;

    /**
     * @var DBLanguage
     */
    protected $language;

    protected int $fkCurrencyId;

    /**
     * @var DBCurrency
     */
    protected $currency;

    /**
     * @var DBLocale
     */
    protected $locale;

    public static function __tableName(): string
    {
        return 'core_dblocale_locales';
    }

    public static function __country(): AbstractDefinition
    {
        return transientField();
    }

    public static function __language(): AbstractDefinition
    {
        return transientField();
    }

    public static function __currency(): AbstractDefinition
    {
        return transientField();
    }

    public static function __locale(): AbstractDefinition
    {
        return transientField();
    }


    public function getLocale(): UtilsLocale
    {
        return UtilsLocale::forLocaleTag($this->localeTag);
    }


    /// generovane gettery a settery

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getLocaleTag(): string
    {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void
    {
        $this->localeTag = $localeTag;
    }

    /**
     * @return int
     */
    public function getFkCountryId(): int
    {
        return $this->fkCountryId;
    }

    /**
     * @param int $fkCountryId
     */
    public function setFkCountryId(int $fkCountryId): void
    {
        $this->fkCountryId = $fkCountryId;
    }

    /**
     * @return DBCountry
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param DBCountry $country
     */
    public function setCountry($country): void
    {
        $this->country = $country;
    }

    /**
     * @return int
     */
    public function getFkLanguageId(): int
    {
        return $this->fkLanguageId;
    }

    /**
     * @param int $fkLanguageId
     */
    public function setFkLanguageId(int $fkLanguageId): void
    {
        $this->fkLanguageId = $fkLanguageId;
    }

    /**
     * @return DBLanguage
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param DBLanguage $language
     */
    public function setLanguage($language): void
    {
        $this->language = $language;
    }

    /**
     * @return int
     */
    public function getFkCurrencyId(): int
    {
        return $this->fkCurrencyId;
    }

    /**
     * @param int $fkCurrencyId
     */
    public function setFkCurrencyId(int $fkCurrencyId): void
    {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    /**
     * @return DBCurrency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param DBCurrency $currency
     */
    public function setCurrency($currency): void
    {
        $this->currency = $currency;
    }
}
