<?php

namespace IZON\DBLocale\Domain;

class DBLanguage extends Language // @phpstan-ignore class.extendsDeprecatedClass
{
    protected ?int $id = null;

    protected string $code;

    protected string $name;

    protected bool $enabled;

    protected string $localeTag;

    public static function __tableName(): string
    {
        return 'core_dblocale_languages';
    }

    /**
     * @return string
     * @deprecated use getLocaleTag() instead
     */
    public function getLocaleCode(): string
    {
        return $this->getLocaleTag();
    }

    /// generated getters and setters

    /**
     * @return string
     */
    public function getLocaleTag(): string
    {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void
    {
        $this->localeTag = $localeTag;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled(bool $enabled): void
    {
        $this->enabled = $enabled;
    }
}
