<?php

namespace IZON\DBLocale\Domain;

class DBCurrency extends Currency // @phpstan-ignore class.extendsDeprecatedClass
{
    protected ?int $id = null;

    protected string $code;

    protected string $htmlString;

    /**
     * @var int number of decimal places to round to
     */
    protected int $rounding;

    /**
     * @var string pod jakym kodem je ulozeno vlocale
     */
    protected string $localeTag;

    public static function __tableName(): string
    {
        return 'core_dblocale_currencies';
    }

    /**
     * @return string
     * @deprecated use getLocaleTag() instead
     */
    public function getLocaleCode(): string
    {
        return $this->getLocaleTag();
    }

    /// generovane getttery a settery

    /**
     * @return string
     */
    public function getLocaleTag(): string
    {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void
    {
        $this->localeTag = $localeTag;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getHtmlString(): string
    {
        return $this->htmlString;
    }

    /**
     * @param string $htmlString
     */
    public function setHtmlString(string $htmlString): void
    {
        $this->htmlString = $htmlString;
    }

    /**
     * @return int
     */
    public function getRounding(): int
    {
        return $this->rounding;
    }

    /**
     * @param int $rounding
     */
    public function setRounding(int $rounding): void
    {
        $this->rounding = $rounding;
    }
}
