<?php

namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;
use IZON\DB\Definitions\AbstractDefinition;
use function IZON\DB\transientField;

/**
 * @deprecated Use DBCountry instead
 * @see \IZON\DBLocale\Domain\DBCountry
 */
class Country implements DBObject
{
    protected ?int $id = null;

    protected string $code;

    protected string $name;

    protected bool $enabled;

    protected int $fkCurrencyId;

    protected DBCurrency $currency;

    protected DBLanguage $language;

    protected DBLocale $locale;
    protected string $shortCut;
    /**
     * TODO: jakmile se bude vytvaret nekompatibilni verze sjednotit localeTag a localeCode v tridach
     * @var string
     */
    protected string $localeTag;

    public static function __tableName(): string
    {
        return 'core_dblocale_countries';
    }

    public static function __currency(): AbstractDefinition
    {
        return transientField();
    }

    public static function __language(): AbstractDefinition
    {
        return transientField();
    }

    public static function __locale(): AbstractDefinition
    {
        return transientField();
    }

    /**
     * @return string
     * @deprecated use getLocaleTag() instead
     */
    public function getLocaleCode(): string
    {
        return $this->getLocaleTag();
    }

    /// generovane gettery a settery

    /**
     * @return string
     */
    public function getLocaleTag(): string
    {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void
    {
        $this->localeTag = $localeTag;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled(bool $enabled): void
    {
        $this->enabled = $enabled;
    }

    /**
     * @return int
     */
    public function getFkCurrencyId(): int
    {
        return $this->fkCurrencyId;
    }

    /**
     * @param int $fkCurrencyId
     */
    public function setFkCurrencyId(int $fkCurrencyId): void
    {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    /**
     * @return DBCurrency
     */
    public function getCurrency(): DBCurrency
    {
        return $this->currency;
    }

    /**
     * @param DBCurrency $currency
     */
    public function setCurrency(DBCurrency $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * @return DBLanguage
     */
    public function getLanguage(): DBLanguage
    {
        return $this->language;
    }

    /**
     * @param DBLanguage $language
     */
    public function setLanguage(DBLanguage $language): void
    {
        $this->language = $language;
    }

    /**
     * @return DBLocale
     */
    public function getLocale(): DBLocale
    {
        return $this->locale;
    }

    /**
     * @param DBLocale $locale
     */
    public function setLocale(DBLocale $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getShortCut(): string
    {
        return $this->shortCut;
    }

    /**
     * @param string $shortCut
     */
    public function setShortCut(string $shortCut): void
    {
        $this->shortCut = $shortCut;
    }
}
