<?php

namespace IZON\DBLocale\Dao;

use IZON\DB\Dao;
use IZON\DB\QueryResult;
use IZON\DBLocale\Domain\DBCurrency;

/**
 * @extends Dao<DBCurrency>
 */
interface DBCurrencyDao extends Dao
{
    /**
     * pro jakou tridu se toto dao pouziva
     */
    public const DOMAIN_CLASS = DBCurrency::class;

    /**
     * Find all galleries in section, preferring those farther from root
     * @param string $localeTag
     * @return QueryResult<DBCurrency>
     */
    public function findCurrencyByLocaleTag(string $localeTag): QueryResult;
}
