<?php

namespace IZON\AppModules\Galleries\DB\GalleryDao;

use IZON\DB\QueryHelpers;
use IZON\DBLocale\Domain\DBLocale;

return [
    'findCurrencyByLocaleTag_1' => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            $cucencyAlias = $queryHelpers->createTableAlias("currency");
            $localeAlias = $queryHelpers->createTableAlias("locale", DBLocale::class);

            $query = "
                SELECT DISTINCT {$cucencyAlias->getClassProperties()}
                FROM {$cucencyAlias->getTableName()}
                    JOIN {$localeAlias->getTableName()}
                        ON {$cucencyAlias->getColumnName("id")} = {$localeAlias->getColumnName('fkCurrencyId')}
                WHERE {$localeAlias->getColumnName('localeTag')} = {$queryHelpers->getParameterName(0)}
                LIMIT :maxResults
                OFFSET :firstResult
             ";

            //            echo($query);
            return $query;
        }
    ],
];
