<?php

namespace IZON\DBLocale\Interceptor;

use IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\CurrencyDao;
use IZON\DBLocale\Dao\LanguageDao;
use IZON\DBLocale\Dao\LocaleDao;
use IZON\DBLocale\Domain\Locale;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * Nastavuje informace o lokalizaci - zemi, jazyk, měnu...
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class LocaleInterceptor {

    /**
     * Pod jaky nazvem je informace o locale dostupny
     */
    const AVAILABLE_AS = '_locale';

    protected CountryDao $countryDao;

    protected CurrencyDao $currencyDao;

    protected LanguageDao $languageDao;

    /**
     *
     * @var LocaleDao
     */
    protected $localeDao;

    public function __construct(
        CountryDao $countryDao,
        CurrencyDao $currencyDao,
        LanguageDao $languageDao,
        LocaleDao $localeDao
    ) {
        $this->countryDao = $countryDao;
        $this->currencyDao = $currencyDao;
        $this->languageDao = $languageDao;
        $this->localeDao = $localeDao;
    }

    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function postHandle(HttpRequest $request, ModelAndView $mav) {
        $mav->putParameter(self::AVAILABLE_AS, $request->getParameter(self::AVAILABLE_AS));
    }

    public function preHandle(HttpRequest $request) {
        $_locale = $request->getLocale();
        /* @var $locale Locale */
        $locale = $this->localeDao->find(array('localeTag' => $_locale->getLanguage().'-'.$_locale->getCountry()))
            ->uniqueResult();
        $locale->setCountry($this->countryDao->load($locale->getFkCountryId()));
        $locale->setCurrency($this->currencyDao->load($locale->getFkCurrencyId()));
        $locale->setLanguage($this->languageDao->load($locale->getFkLanguageId()));

        $request->setSessionParameter(self::AVAILABLE_AS, $locale);
        $request->addParameter(self::AVAILABLE_AS, $locale);
    }
}
