<?php
namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;
use IZON\DB\Definitions\AbstractDefinition;
use function IZON\DB\transientField;
use IZON\Utils\Locale as UtilsLocale;

/**
 * Description of Locale
 * @author Vítězslav Jahn, IZON s.r.o. <jahn@izon.cz>
 */
class Locale implements DBObject {

    public static function __tableName(): string { return 'core_dblocale_locales'; }

    protected ?int $id = null;

    /**
     * @var string jak je otagovano locale podle RFC http://php.net/manual/en/class.locale.php
     */
    protected string $localeTag;

    protected int $fkCountryId;

    protected Country $country;
    public static function __country(): AbstractDefinition { return transientField(); }

    protected int $fkLanguageId;

    protected Language $language;
    public static function __language(): AbstractDefinition { return transientField(); }

    /**
     * @var integer
     */
    protected int $fkCurrencyId;

    protected Currency $currency;
    public static function __currency(): AbstractDefinition { return transientField(); }

    protected Locale $locale;
    public static function __locale(): AbstractDefinition  { return transientField(); }


    public function getLocale(): UtilsLocale {
        return UtilsLocale::forLocaleTag($this->localeTag);
    }


/// generovane gettery a settery
    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getLocaleTag(): string {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void {
        $this->localeTag = $localeTag;
    }

    /**
     * @return int
     */
    public function getFkCountryId(): int {
        return $this->fkCountryId;
    }

    /**
     * @param int $fkCountryId
     */
    public function setFkCountryId(int $fkCountryId): void {
        $this->fkCountryId = $fkCountryId;
    }

    /**
     * @return Country
     */
    public function getCountry(): Country {
        return $this->country;
    }

    /**
     * @param Country $country
     */
    public function setCountry(Country $country): void {
        $this->country = $country;
    }

    /**
     * @return int
     */
    public function getFkLanguageId(): int {
        return $this->fkLanguageId;
    }

    /**
     * @param int $fkLanguageId
     */
    public function setFkLanguageId(int $fkLanguageId): void {
        $this->fkLanguageId = $fkLanguageId;
    }

    /**
     * @return Language
     */
    public function getLanguage(): Language {
        return $this->language;
    }

    /**
     * @param Language $language
     */
    public function setLanguage(Language $language): void {
        $this->language = $language;
    }

    /**
     * @return int
     */
    public function getFkCurrencyId(): int {
        return $this->fkCurrencyId;
    }

    /**
     * @param int $fkCurrencyId
     */
    public function setFkCurrencyId(int $fkCurrencyId): void {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    /**
     * @return Currency
     */
    public function getCurrency(): Currency {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency(Currency $currency): void {
        $this->currency = $currency;
    }
}
