<?php
namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;
use IZON\DB\Definitions\AbstractDefinition;
use IZON\DB\Definitions\TransientDefinition;
use function IZON\DB\transientField;

/**
 * Description of Country
 * @author Vítězslav Jahn, IZON s.r.o. <jahn@izon.cz>
 */
class Country implements DBObject {

    public static function __tableName(): string { return 'core_dblocale_countries'; }

    protected ?int $id = null;

    protected string $code;

    protected string $name;

    protected bool $enabled;

    protected int $fkCurrencyId;

    protected Currency $currency;
    public static function __currency(): AbstractDefinition { return transientField(); }

    protected Language $language;
    public static function __language(): AbstractDefinition { return transientField(); }

    protected Locale $locale;
    public static function __locale(): AbstractDefinition { return transientField(); }

    protected string $shortCut;

    /**
     * TODO: jakmile se bude vytvaret nekompatibilni verze sjednotit localeTag a localeCode v tridach
     * @var string
     */
    protected string $localeTag;

    /**
     * @deprecated use getLocaleTag() instead
     * @return string
     */
    public function getLocaleCode(): string {
        return $this->getLocaleTag();
    }

/// generovane gettery a settery
    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param int|null $id
     */
    public function setId(?int $id): void {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCode(): string {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void {
        $this->name = $name;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled(bool $enabled): void {
        $this->enabled = $enabled;
    }

    /**
     * @return int
     */
    public function getFkCurrencyId(): int {
        return $this->fkCurrencyId;
    }

    /**
     * @param int $fkCurrencyId
     */
    public function setFkCurrencyId(int $fkCurrencyId): void {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    /**
     * @return Currency
     */
    public function getCurrency(): Currency {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency(Currency $currency): void {
        $this->currency = $currency;
    }

    /**
     * @return Language
     */
    public function getLanguage(): Language {
        return $this->language;
    }

    /**
     * @param Language $language
     */
    public function setLanguage(Language $language): void {
        $this->language = $language;
    }

    /**
     * @return Locale
     */
    public function getLocale(): Locale {
        return $this->locale;
    }

    /**
     * @param Locale $locale
     */
    public function setLocale(Locale $locale): void {
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getShortCut(): string {
        return $this->shortCut;
    }

    /**
     * @param string $shortCut
     */
    public function setShortCut(string $shortCut): void {
        $this->shortCut = $shortCut;
    }

    /**
     * @return string
     */
    public function getLocaleTag(): string {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void {
        $this->localeTag = $localeTag;
    }
}
