<?php

namespace IZON\DBLocale\Dao;

use IZON\DB\Dao;
use IZON\DB\QueryResult;
use IZON\DBLocale\Domain\Currency;

/**
 * @extends Dao<Currency>
 */
interface CurrencyDao extends Dao {

    /**
     * pro jakou tridu se toto dao pouziva
     */
    const DOMAIN_CLASS = Currency::class;

    /**
     * Find all galleries in section, preferring those farther from root
     * @param string $localeTag
     * @return QueryResult<Currency>
     */
    public function findCurrencyByLocaleTag(string $localeTag): QueryResult;
}
