<?php
namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;

/**
 * Description of Locale
 * @author Vítězslav Jahn, IZON s.r.o. <jahn@izon.cz>
 */
class Locale implements DBObject {
  
    public static function __tableName() { return 'core_dblocale_locales'; }

    /**
     * @var integer
     */
    protected $id;

    /**
     * TODO: jakmile se bude vytvaret nekompatibilni verze sjednotit localeTag a localeCode v tridach
     * @var string jak je otagovano locale podle RFC http://php.net/manual/en/class.locale.php
     */
    protected $localeTag;

    /**
     * @var integer
     */
    protected $fkCountryId;

    /**
     * @var Country
     */
    protected $country;
    public static function __country() { return \IZON\DB\transientField(); }

    /**
     * @var integer
     */
    protected $fkLanguageId;

    /**
     * @var Language
     */
    protected $language;
    public static function __language() { return \IZON\DB\transientField(); }

    /**
     * @var integer
     */
    protected $fkCurrencyId;
    
    /**
     * @var Currency
     */
    protected $currency;
    public static function __currency() { return \IZON\DB\transientField(); }

    /**
     * @var \IZON\Utils\Locale
     */
    protected $locale;
    public static function __locale()  { return \IZON\DB\transientField(); }
    
    
    
    /// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getLocaleTag() {
        return $this->localeTag;
    }

    function getFkCountryId() {
        return $this->fkCountryId;
    }

    function getCountry() {
        return $this->country;
    }

    function getFkLanguageId() {
        return $this->fkLanguageId;
    }

    function getLanguage() {
        return $this->language;
    }

    function getFkCurrencyId() {
        return $this->fkCurrencyId;
    }

    function getCurrency() {
        return $this->currency;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setLocaleTag($localeTag) {
        $this->localeTag = $localeTag;
    }

    function setFkCountryId($fkCountryId) {
        $this->fkCountryId = $fkCountryId;
    }

    function setCountry(Country $country) {
        $this->country = $country;
    }

    function setFkLanguageId($fkLanguageId) {
        $this->fkLanguageId = $fkLanguageId;
    }

    function setLanguage(Language $language) {
        $this->language = $language;
    }

    function setFkCurrencyId($fkCurrencyId) {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    function setCurrency(Currency $currency) {
        $this->currency = $currency;
    }

    /**
     * @return \IZON\Utils\Locale
     */
    public function getLocale() {
        return $this->locale;
    }

    /**
     * @param \IZON\Utils\Locale $locale
     */
    public function setLocale($locale) {
        $this->locale = $locale;
    }


}
