<?php
namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;

/**
 * reprezentuje nejakou rec
 */
class Language implements DBObject {
    
    public static function __tableName() { return 'core_dblocale_languages'; }
    
    /**
     * @var integer
     */
    protected $id;
    
    /**
     * @var string
     */
    protected $code;
    
    /**
     * Sjenoceni stejne s country
     * TODO: v dalsi verzi zmenit i v db
     * @var string
     */
    protected $name;
    public static function __name() { return \IZON\DB\charField(["columnName" => 'title']); }
    
    /**
     * @var integer
     */
    protected $enabled;

    /**
     * @var string pod jakym kodem je ulozeno vlocale
     */
    protected $localeCode;
    
    
    /// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getCode() {
        return $this->code;
    }

    function getName() {
        return $this->name;
    }

    function getEnabled() {
        return $this->enabled;
    }

    function getLocaleCode() {
        return $this->localeCode;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setEnabled($enabled) {
        $this->enabled = $enabled;
    }

    function setLocaleCode($localeCode) {
        $this->localeCode = $localeCode;
    }
    
    public function getTitle() {
      return $this->getName();
    }
}
