<?php
namespace IZON\DBLocale\Domain;

use IZON\DB\DBObject;

/**
 * Description of Country
 * @author Vítězslav Jahn, IZON s.r.o. <jahn@izon.cz>
 */
class Country implements DBObject {
  
    public static function __tableName() { return 'core_dblocale_countries'; }

    /**
     * @var integer
     */
    protected $id;
    
    /**
     * @var string
     */
    protected $code;
    
    /**
     * @var string
     */
    protected $name;
    
    /**
     * @var integer
     */
    protected $enabled;
    
    /**
     * @var integer
     */
    protected $fkCurrencyId;

    /**
     * @var Currency
     */
    protected $currency;
    public static function __currency() { return \IZON\DB\transientField(); }
    
    /**
     * @var Language
     */
    protected $language;
    public static function __language() { return \IZON\DB\transientField(); }
    
    /**
     * @var Locale
     */
    protected $locale;
    public static function __locale() { return \IZON\DB\transientField(); }
    
    /**
     * @var string
     */
    protected $shortCut;
    
    /**
     * TODO: jakmile se bude vytvaret nekompatibilni verze sjednotit localeTag a localeCode v tridach
     * @var string
     */
    protected $localeCode;

    
/// generovane gettery a settery    
    function getId() {
        return $this->id;
    }

    function getCode() {
        return $this->code;
    }

    function getName() {
        return $this->name;
    }

    function getEnabled() {
        return $this->enabled;
    }

    function getFkCurrencyId() {
        return $this->fkCurrencyId;
    }

    function getCurrency() {
        return $this->currency;
    }

    function getLanguage() {
        return $this->language;
    }

    function getShortCut() {
        return $this->shortCut;
    }

    function getLocaleCode() {
        return $this->localeCode;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setCode($code) {
        $this->code = $code;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setEnabled($enabled) {
        $this->enabled = $enabled;
    }

    function setFkCurrencyId($fkCurrencyId) {
        $this->fkCurrencyId = $fkCurrencyId;
    }

    function setCurrency(Currency $currency) {
        $this->currency = $currency;
    }

    function setLanguage(Language $language) {
        $this->language = $language;
    }

    function setShortCut($shortCut) {
        $this->shortCut = $shortCut;
    }

    function setLocaleCode($localeCode) {
        $this->localeCode = $localeCode;
    }
    public function getLocale() {
      return $this->locale;
    }

    public function setLocale(Locale $locale) {
      $this->locale = $locale;
    }


}
