<?php
namespace IZON\AppModules\Galleries\DB\GalleryDao;

use IZON\DB\QueryHelpers;

use IZON\DBLocale\Domain\Locale;

return[
    'findCurrencyByLocaleTag_1' => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $cucencyAlias = $queryHelpers->createTableAlias("currency");
            $localeAlias = $queryHelpers->createTableAlias("locale", Locale::class);
            
            $query = "select distinct ". $cucencyAlias->getClassProperties()
                    .' from '. $cucencyAlias->getTableName()
                        .' join '. $localeAlias->getTableName()
                            .' on '. $cucencyAlias->getColumnName("id")
                                .' = '. $localeAlias->getColumnName('fkCurrencyId');
            
            $query .= " where ". $localeAlias->getColumnName('localeTag') ." = ". $queryHelpers->getParameterName(0);
            
            $query .= " limit :maxResults offset :firstResult";

//            echo($query);
            return $query;
        }
    ],
];