<?php



namespace IZON\DB\Files\Helpers;

/**
 *
 * @author lukas
 */
interface EntityWrapperInterface
{
    /**
     *
     * @return string class
     */
    public function getEntityClass(): string;

    /**
     * @return object
     */
    public function getEntity();

    /**
     *
     * @return string
     */
    public function getUID(): string;

    /**
     *
     * @return PropertyWrapper[]
     */
    public function getFileProperties(): array;

    /**
     *
     * @param string $name
     * @return bool
     */
    public function isFileProperty(string $name): bool;

    /**
     *
     * @param string $name
     * @return PropertyWrapper
     */
    public function getFileProperty(string $name): PropertyWrapper;

    /**
     *
     * @return bool
     */
    public function hasAnyFileProperty(): bool;

    /**
     * return table name like "table_name"
     * @return string
     */
    public function getTableName(): string;

    public function recomputeChangeSet(): void;
}
