<?php

namespace IZON\DB\Files\Helpers;

use IZON\Transliterator\Slug;

class FileUtils {
    public static function getSafeFileName(string $name) : string {
        $fileName = strtolower(pathinfo($name, PATHINFO_FILENAME));
        $fileExtension = pathinfo($name, PATHINFO_EXTENSION);

        $name = Slug::createSlug($fileName);

        if(trim($name) == '') {
            // pokud je celej nazev souboru spatne, tak se mu da nejaky defaultni nazev ve tvaru "default_[rand(0, 1000000)].[puvodni_pripona]"
            $name = 'default_' . rand(0, 1000000);
        }
        return strtolower(implode('.', array_filter([$name,$fileExtension])));
    }
}
