<?php

namespace IZON\DB\Files;

use Doctrine\Common\EventSubscriber;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Events;
use IZON\DB\Files\Helpers\EntityWrapper;

class FileEventSubscriber implements EventSubscriber {

    /**
     *
     * @var FilePropertyEntityProcessor
     */
    protected $entityProcessor;

    public function __construct(FilePropertyEntityProcessor $entityProcessor) {
        $this->entityProcessor = $entityProcessor;
    }

    public function getSubscribedEvents() {
        return [
            Events::postLoad,
            Events::prePersist,
            Events::postPersist,
            Events::preUpdate,
            Events::postUpdate,
            Events::postRemove
        ];
    }

    // -------------------------------------------------------------------------
    // LOADING FILE
    // -------------------------------------------------------------------------

    public function postLoad(LifecycleEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager());
        $this->entityProcessor->postLoad($entityWrapper);
    }

    // -------------------------------------------------------------------------
    // PERSIST
    // -------------------------------------------------------------------------


    public function prePersist(LifecycleEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager(), false);
        $this->entityProcessor->prePersist($entityWrapper);
    }

    public function postPersist(LifecycleEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager());
        $this->entityProcessor->postPersist($entityWrapper);
    }

    // -------------------------------------------------------------------------
    // UPDATE
    // -------------------------------------------------------------------------
    public function preUpdate(PreUpdateEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager());

        $oldValues = [];
        foreach ($args->getEntityChangeSet() as $name => $values) {
            $oldValues[$name] = $values[0];
        }

        $this->entityProcessor->preUpdate($entityWrapper, $oldValues);
    }

    public function postUpdate(LifecycleEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager());
        $this->entityProcessor->postUpdate($entityWrapper);
    }

    // -------------------------------------------------------------------------
    // REMOVE
    // -------------------------------------------------------------------------
    public function postRemove(LifecycleEventArgs $args) {
        $entityWrapper = new EntityWrapper($args->getObject(), $args->getObjectManager());
        $this->entityProcessor->postRemove($entityWrapper);
    }

}
