<?php

namespace IZON\DB\Files\Proxies;

use IZON\IO\FileInterface;
use IZON\IO\RasterImageInterface;

/**
 * proxy object that represents
 */
class RasterImageProxy extends FileProxy implements RasterImageInterface {

    /**
     * @var int
     */
    protected $pixelWidth;

    /**
     * @var int
     */
    protected $pixelHeight;

    public function __construct(
        string $fileName,
        int $fileSize,
        string $mimeType,
        int $timestamp,
        int $pixelWidth,
        int $pixelHeight
    ) {
        parent::__construct($fileName, $fileSize, $mimeType, $timestamp);
        $this->pixelWidth = $pixelWidth;
        $this->pixelHeight = $pixelHeight;
    }

    public static function createFromFile(FileInterface $file) {
        /** @var RasterImageInterface $dbFile */
        $dbFile = new static(
            $file->getFileName(),
            $file->getFileSize(),
            $file->getMimeType(),
            $file->getTimestamp(),
            $file->getPixelWidth(),
            $file->getPixelHeight()
        );
        return $dbFile;
    }

    public function getPixelWidth(): int {
        return $this->pixelWidth;
    }

    public function getPixelHeight(): int {
        return $this->pixelHeight;
    }

}
