<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\DB\Files\Helpers;

/**
 *
 * @author lukas
 */
interface EntityWrapperInterface {

    /**
     *
     * @return string class
     */
    public function getEntityClass(): string;

    /**
     * @return entity
     */
    public function getEntity();

    /**
     *
     * @return string
     */
    public function getUID(): string;

    /**
     *
     * @return PropertyWrapper[]
     */
    public function getFileProperties(): array;

    /**
     *
     * @param string $name
     * @return bool
     */
    public function isFileProperty(string $name): bool;

    /**
     *
     * @param string $name
     * @return PropertyWrapper
     */
    public function getFileProperty(string $name): PropertyWrapper;

    /**
     *
     * @return bool
     */
    public function hasAnyFileProperty(): bool;

    /**
     * return table name like "table_name"
     * @return string
     */
    public function getTableName(): string;

    /**
     * return table name like "tableName"
     * @return string
     */
    public function getCamelizeTableName(): string;

    public function recomputeChangeSet();
}
