<?php

namespace IZON\DB\Files\Proxies;

use Exception;
use IZON\IO\AbstractFile;
use IZON\IO\FileInterface;
use League\Flysystem\FilesystemInterface;
use Serializable;

/**
 * proxy object that represents
 */
class FileProxy extends AbstractFile implements FileInterface{

    /**
     * @var string
     */
    protected $fileName;

    /**
     * @var int
     */
    protected $fileSize;

    /**
     * @var string
     */
    protected $mimeType;
    /**
     *
     * @var int
     */
    protected $timestamp;
    /**
     *
     * @var FilesystemInterface
     */
    protected $filesystem;
    /**
     *
     * @var string
     */
    protected $path;
    /**
     *
     * @var bool
     */
    protected $injected = false;


    function __construct($fileName, $fileSize, $mimeType, $timestamp) {
        $this->fileName = $fileName;
        $this->fileSize = $fileSize;
        $this->mimeType = $mimeType;
        $this->timestamp = $timestamp;
    }

    public static function createFromFile(FileInterface $file) {
        $dbFile = new static(
            $file->getFileName(),
            $file->getFileSize(),
            $file->getMimeType(),
            $file->getTimestamp()
        );
        return $dbFile;
    }

    public function getFileExtension(): string {
        $explodedName = explode('.', $this->fileName);
        return $explodedName[count($explodedName)-1];
    }

    public function getFileName(): string {
        return $this->fileName;
    }

    public function getFileSize(): int {
        return $this->fileSize;
    }

    public function getMimeType(): string {
        return $this->mimeType;
    }

    public function getFileContents(): string {
        if(!$this->injected) {
            // DOTO better exception
            throw new Exception('Proxy is not filed with filesystem and name');
        }
        $content =  $this->filesystem->read($this->path);
        if($content === false) {
            throw new Exception("Reading of file '{$this->path}' faild.");
        }
        return $content;
    }

    public function getFileStream() {
        if(!$this->injected) {
            // DOTO better exception
            throw new Exception('Proxy is not filed with filesystem and name');
        }
        $resource = $this->filesystem->readStream($this->path);
        if($resource === false) {
            throw new Exception("Reading of file '{$this->path}' faild.");
        }
        return $resource;
    }

    public function getTimestamp(): int {
        return $this->timestamp;
    }

    public function injectSource(FilesystemInterface $filesystem, string $path) {
        $this->filesystem = $filesystem;
        $this->path = $path;
        $this->injected = true;
    }

    public function getPath() {
       return $this->path;
    }

    public function getOriginUID(): ?string {
        return $this->filesystem->getFilesystemUID();
    }

    public function getFileUID(): string {
        return $this->getPath();
    }


}
