<?php


namespace IZON\Date;

use DateInterval;

class DateIntervalFactory
{
    /**
     * Make Date interval from number of time arguments
     * @param int $seconds count of seconds in interval
     * @param int $minutes count of minutes in interval
     * @param int $hours count of hours in interval
     * @param int $days count of days in interval
     * @param int $months count of months in interval
     * @param int $years count of years in interval
     * @return DateInterval
     *
     * makeInterval should be brobbaby protected method
     * $seconds should be required as parameter
     *
     * @throws DateException
     */
    public static function makeInterval(
        int $seconds = 0,
        int $minutes = 0,
        int $hours = 0,
        int $days = 0,
        int $months = 0,
        int $years = 0
    ): DateInterval {
        foreach (func_get_args() as $key => $arg) {
            if (!is_numeric($arg)) {
                //number of argument start on 0
                throw new DateException('Interval of argument number: ' . $key . ' is not integer');
            }
            if ($arg < 0) {
                //number of argument start on 0
                throw new DateException('Interval of argument number: ' . $key . ' can not be negative');
            }
        }
        $intervalString = "";

        $intervalString .= "P";
        $intervalString .= $years . "Y";
        $intervalString .= $months . "M";
        $intervalString .= $days . "D";

        $intervalString .= "T";
        $intervalString .= $hours . "H";
        $intervalString .= $minutes . "M";
        $intervalString .= $seconds . "S";

        $interval = new DateInterval($intervalString);
        return $interval;
    }
}
