<?php

declare(strict_types=1);

namespace IZON\DataGrid\Filter;

use Nette\Forms\Controls\Button;
use Nette\Utils\Html;
use IZON\DataGrid\DataGrid;
use IZON\DataGrid\Traits\TButtonClass;
use IZON\DataGrid\Traits\TButtonIcon;
use IZON\DataGrid\Traits\TButtonText;
use IZON\DataGrid\Traits\TButtonTitle;
use IZON\DataGrid\Traits\TButtonTryAddIcon;

class SubmitButton extends Button
{

	use TButtonTryAddIcon;
	use TButtonIcon;
	use TButtonClass;
	use TButtonTitle;
	use TButtonText;

	/**
	 * @var DataGrid
	 */
	protected $grid;


	public function __construct(DataGrid $grid)
	{
		parent::__construct($this->text);

		$this->grid = $grid;

		$this->text = 'ublaboo_datagrid.filter_submit_button';
		$this->class = 'btn btn-sm btn-primary';
		$this->icon = 'search';

		$this->control = Html::el('button', ['type' => 'submit', 'name' => 'submit']);
	}


	/**
	 * @param  string|object  $caption
	 */
	public function getControl($caption = null): Html
	{
		$el = parent::getControl($caption);

		$el->setAttribute('type', 'submit');
		$el->setAttribute('class', $this->getClass());

		if ($this->getIcon() !== null) {
			$el->addHtml(
				Html::el('span')->appendAttribute(
					'class',
					DataGrid::$iconPrefix . $this->getIcon()
				)
			);

			if ($this->getText() !== '') {
				$el->addHtml('&nbsp;');
			}
		}

		$el->addText($this->grid->getTranslator()->translate($this->getText()));

		return $el;
	}
}
