<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Toolbar\AToolbar;
use IZON\DataGrid\Toolbar\ToolbarModuleLink;
use IZON\DataGrid\Exception\DataGridColumnExistException;

trait TDataGridToolbars {

    /** @var AToolbar[] */
    protected $toolbars = [];

    # GETTERS

    /**
     * @return AToolbar[]
     */
    public function getToolbars(): array {
        return $this->toolbars;
    }

    # SETTERS

    /**
     * @return mixed
     */
    protected function addToolbar(string $key, AToolbar $action) {
        if(isset($this->toolbars[$key])) {
            throw new DataGridColumnExistException($key);
        }

        $action->setModule($this->module);
        $action->setDataGrid($this);

        $this->toolbars[$key] = $action;
        return $action;
    }

    // TOOLBARS

    public function addToolbarModule(string $key, ?string $name, string $method, array $params = []): ToolbarModuleLink {
        $column = new ToolbarModuleLink($key, $name, $method, $params);
        return $this->addToolbar($key, $column);
    }
}
