<?php

declare(strict_types=1);

namespace IZON\DataGrid;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\QueryBuilder;
use IZON\DataGrid\Components\DataGridPaginator\DataGridPaginator;
use IZON\DataGrid\DataSource\ArrayDataSource;
use IZON\DataGrid\DataSource\DoctrineCollectionDataSource;
use IZON\DataGrid\DataSource\DoctrineDataSource;
use IZON\DataGrid\DataSource\IDataSource;
use IZON\DataGrid\DataSource\PaginatorConfigDataSource;
use IZON\DataGrid\Exception\DataGridWrongDataSourceException;
use IZON\DataGrid\Exception\DataGrigMissingDaoException;
use IZON\DataGrid\Utils\PaginatorDataSource;
use IZON\DB\Dao;
use IZON\DB\Paginator\PaginatorConfig;

class DataSource {

    /**
     * @param mixed $source
     */
    public static function createDataSource($source, string $primaryKey = 'id', ?Dao $dao = null) {
        if($source instanceof IDataSource) {
            return $source;

        } elseif(is_array($source)) {
            $source = new ArrayDataSource($source);

        } elseif($source instanceof PaginatorDataSource) {
            $source = new PaginatorConfigDataSource($source, $primaryKey);

        } elseif($source instanceof QueryBuilder) {
            $source = new DoctrineDataSource($source, $primaryKey);

        } elseif($source instanceof Collection) {
            $source = new DoctrineCollectionDataSource($source, $primaryKey);

        } else {
            throw new DataGridWrongDataSourceException(is_object($source) ? get_class($source) : 'null');
        }

        return $source;
    }

}
