<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Column\ColumnChangeProperty;
use IZON\DataGrid\Column\ColumnEmail;
use IZON\DataGrid\Column\ColumnModuleLink;
use IZON\DataGrid\Column\ColumnPhone;
use IZON\DataGrid\Exception\DataGridColumnExistException;
use IZON\DataGrid\Column\AColumn;
use IZON\DataGrid\Column\ColumnAbsLink;
use IZON\DataGrid\Column\ColumnDateTime;
use IZON\DataGrid\Column\ColumnLink;
use IZON\DataGrid\Column\ColumnText;

trait TDataGridColumns {

    /** @var AColumn[] */
    protected $columns;

    /** @var array|callable[] */
    public $onColumnAdd = [];

    # GETTERS

    /**
     * @return AColumn[]
     */
    public function getColumns(): array {
        return $this->columns;
    }

    # SETTERS

    /**
     * @return mixed
     */
    protected function addColumn(string $key, AColumn $column) {
        if(isset($this->columns[$key])) {
            throw new DataGridColumnExistException($key);
        }

        $column->setModule($this->module);
        $column->setDataGrid($this);

        foreach($this->onColumnAdd as $onColumnAdd) {
            $onColumnAdd($key, $column);
        }

        $this->columns[$key] = $column;
        return $column;
    }

    public function addColumnText(string $key, string $name, ?string $column = null): ColumnText {
        $column = new ColumnText($key, $name, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnLink(string $key, string $name, callable $link, bool $targetBlank = false, ?string $column = null): ColumnLink {
        $column = new ColumnLink($key, $name, $link, $targetBlank, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnModuleLink(string $key, string $name, string $method, array $params, bool $targetBlank = false, ?string $column = null): ColumnModuleLink {
        $column = new ColumnModuleLink($key, $name, $method, $params, $targetBlank, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnAbsLink(string $key, string $name, ?string $column = null): ColumnAbsLink {
        $column = new ColumnAbsLink($key, $name, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnChangeProperty(string $key, string $name, ?string $column = null): ColumnChangeProperty {
        $column = new ColumnChangeProperty($key, $name, $column);
        $column->setAlign(AColumn::ALIGN_CENTER);
        return $this->addColumn($key, $column);
    }

    public function addColumnDateTime(string $key, string $name, string $format = 'd.m.Y H:i', ?string $column = null): ColumnDateTime {
        $column = new ColumnDateTime($key, $name, $format, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnEmail(string $key, string $name, ?string $column = null): ColumnEmail {
        $column = new ColumnEmail($key, $name, $column);
        return $this->addColumn($key, $column);
    }

    public function addColumnPhone(string $key, string $name, ?string $column = null): ColumnPhone {
        $column = new ColumnPhone($key, $name, $column);
        return $this->addColumn($key, $column);
    }

}
