<?php

namespace IZON\DataGrid\Render;

use IZON\DataGrid\DataGrid;

class RenderStyle implements IRender {

    private static $wasRendered = false;

    public static function render(DataGrid $dataGrid): void {
        if(self::$wasRendered) {
            return;
        }
        self::$wasRendered = true;
        ?>
        <style>
            .datagrid-align-left {
                text-align: left !important;
            }

            .datagrid-align-center {
                text-align: center !important;
            }

            .datagrid-align-right {
                text-align: right !important;
            }

            .datagrid-column-action {
                white-space: nowrap;
                width: 75px;
            }

            .datagrid-column-group-action {
                white-space: nowrap;
                width: 30px;
            }

            .datagrid-paginator-item {
                border: 1px solid #36d9c3;
                padding: 3px 6px;
                margin: 0px 2px;
            }

            a.datagrid-paginator-item:hover {
                background-color: rgba(54, 217, 195, 0.5);
                text-decoration: none;
            }

            select.datagrid-paginator-item {
                padding: 2.5px 6px;
            }

            .datagrid-paginator-item-active {
                background-color: rgba(54, 217, 195, 0.5);
                text-align: center;
                font-weight: bold;
                width: 40px;
            }

            .datagrid-toolbars,
            .datagrid-filter-outer {
                background-color: transparent !important;
                padding: 5px 0px !important;
                text-align: left !important;
                border: none !important;
            }

            .datagrid-filter-outer {
                padding-bottom: 25px !important;
            }

            .datagrid-toolbars .btn,
            .datagrid-toolbars .btn svg,
            .datagrid-filter-outer .btn,
            .datagrid-filter-outer .btn svg {
                color: white !important;
                text-decoration: none;
            }

            /*.datagrid-paginator-item-active {*/
            /*    border-width: 2px;*/
            /*    font-weight: bold;*/
            /*    text-align: center;*/
            /*    width: 35px;*/
            /*}*/

            .table th:after, .table--dynamic th:after {
                content: none;
            }

            .datagrid-table tbody tr:nth-child(even) {
                background-color: rgba(203, 196, 188, 0.05);
            }

            .datagrid-table tbody tr:hover {
                background-color: rgba(54, 217, 195, 0.1);
            }

            .js-datagrid-sortable-handle {
                cursor: n-resize !important;
            }

            .js-datagrid-sortable-highlight {
                background-color: #ffefbb !important;
            }
        </style>
        <?php
    }
}

