<?php

declare(strict_types=1);

namespace IZON\DataGrid\Filter;

use IZON\Forms\Form;

class FilterSelect extends OneColumnFilter {

    /** @var string */
    protected $type = 'select';

    /** @var array */
    protected $options;

    /** @var string */
    protected $prompt = '--';


    public function __construct(string $key, string $name, array $options, string $column) {
        parent::__construct($key, $name, $column);

        $this->options = $options;
    }

    public function addToFormContainer(Form $form): void {
        $this->baseField = $form->addSelectField($this->key, $this->name);
        $this->baseField->setNullOnEmpty(true);
        $this->baseField->setUnselectedText($this->prompt);
        $this->baseField->setOptions($this->options);
    }

    public function getOptions(): array {
        return $this->options;
    }

    public function getCondition(): array {
        return [$this->column => $this->getValue()];
    }

    public function getPrompt(): string {
        return $this->prompt;
    }

    public function setPrompt(string $prompt): self {
        $this->prompt = $prompt;

        return $this;
    }

}
