<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Exception\DataGridColumnExistException;
use IZON\DataGrid\GroupAction\AGroupAction;
use IZON\DataGrid\GroupAction\GroupAction;
use IZON\DataGrid\GroupAction\GroupActionButton;
use IZON\DataGrid\GroupAction\GroupActionExport;
use IZON\DataGrid\GroupAction\GroupActionSelect;

trait TDataGridGroupActions {

    /** @var AGroupAction[] */
    protected $groupActions = [];

    /** @var GroupAction[] */
    protected $groupActionsPrepare = [];

    public function processGroupAction(): void {
        $groupActionName = $this->getRequestParam('groupAction');
        $groupActionValue = null;

        if($groupActionName !== null) {
            $e_groupActionName = explode('::', $groupActionName);

            if(count($e_groupActionName) === 2) {
                list($groupActionName, $groupActionValue) = $e_groupActionName;
            }
        }

        $groupActionIds = $this->getRequestParam('groupActionIds', []);

        $groupAction = null;
        if(isset($this->groupActions[$groupActionName])) {
            $groupAction = $this->groupActions[$groupActionName];
        } elseif(isset($this->groupActionsPrepare[$groupActionName])) {
            $groupAction = $this->groupActionsPrepare[$groupActionName];
        }

        if ($groupAction instanceof AGroupAction) {
            $dataSource = clone $this->getDatasource();

            if (count($groupActionIds) === 0) { // && $groupAction instanceof GroupActionExport) {
                $data = $dataSource;
            } else {
                $data = $dataSource->filterIn('id', $groupActionIds);
            }

            if (count($data->getData()) > 0) {
                $callback = $groupAction->getCallback();

                if ($groupActionValue !== null) {
                    $callback($data->getData(), $groupActionValue);
                } else {
                    $callback($data->getData());
                }
            }
        }
    }

    # GETTERS

    /**
     * @return AGroupAction[]
     */
    public function getGroupActions(): array {
        if(!empty($this->groupActionsPrepare) && !isset($this->groupActions['select'])) {
            $options = [];
            foreach($this->groupActionsPrepare as $groupAction) {
                if(empty($groupAction->getOptions())) {
                    $options[$groupAction->getKey()] = $groupAction->getValue();
                } else {
                    $groupActionOptions = $groupAction->getOptions();
                    $groupActionOptions[AGroupAction::PREFIX_GROUP_ACTION_NAME] = $groupAction->getValue();
                    $options[$groupAction->getKey()] = $groupActionOptions;
                }
            }

            $groupActionSelect = new GroupActionSelect('select', 'Vykonat', $options);
            $this->addGroupAction('select', $groupActionSelect);
        }

        return $this->groupActions;
    }

    # SETTERS

    /**
     * @return mixed
     */
    protected function addGroupAction(string $key, AGroupAction $groupAction) {
        if(isset($this->groupActions[$key])) {
            throw new DataGridColumnExistException($key);
        }

        $groupAction->setModule($this->module);
        $groupAction->setDataGrid($this);

        $this->groupActions[$key] = $groupAction;
        return $groupAction;
    }

    // GROUP ACTIONS

    public function addExport(string $key, ?string $name, ?callable $callback = null): GroupActionExport {
        $groupAction = new GroupActionExport($key, $name, $callback);
        return $this->addGroupAction($key, $groupAction);
    }

    public function addGroupActionButton(string $key, ?string $name, ?callable $callback = null): GroupActionButton {
        $groupAction = new GroupActionButton($key, $name, $callback);
        return $this->addGroupAction($key, $groupAction);
    }

    public function addGroupActionSelect(
        string $key,
        ?string $name,
        ?callable $callback = null,
        array $options = []
    ): GroupAction {
        if(isset($this->groupActionsPrepare[$key])) {
            throw new DataGridColumnExistException($key);
        }

        $groupAction = new GroupAction($key, $name, $callback, $options);
        $groupAction->setModule($this->module);
        $groupAction->setDataGrid($this);

        $this->groupActionsPrepare[$key] = $groupAction;
        return $groupAction;
    }
}
