<?php

namespace IZON\DataGrid\Traits;

use IZON\Admin\MVC\Context\AdminContext;
use IZON\DataGrid\DataGrid;
use IZON\DataGrid\Exception\DataGridControllerCreateGridNotExistException;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

trait TDataGridAjaxController {

    public function ajaxReloadDataGrid(HttpRequest $request, AdminContext $context) {
        $datagridName = $request->getParameter('datagrid');

        $method = sprintf('createGrid%s', ucfirst($datagridName));

        if(!method_exists($this, $method)) {
            throw new DataGridControllerCreateGridNotExistException($method);
        }

        /** @var DataGrid $datagrid */
        $datagrid = $this->$method($request, $context);
        $datagrid->unsetAjaxRender();

        $mav = new ModelAndView('admin/raw-datagrid');
        $mav->putParameter('grid', $datagrid);

        return $mav;
    }
}
