<?php

declare(strict_types=1);

namespace IZON\DataGrid\DataSource;

use Nette\Utils\ArrayHash;
use IZON\DataGrid\Filter\aFilter;
use IZON\DataGrid\Filter\FilterDate;
use IZON\DataGrid\Filter\FilterDateRange;
use IZON\DataGrid\Filter\FilterMultiSelect;
use IZON\DataGrid\Filter\FilterRange;
use IZON\DataGrid\Filter\FilterSelect;
use IZON\DataGrid\Filter\FilterText;

abstract class FilterableDataSource {

    /**
     * {@inheritDoc}
     *
     * @param array<aFilter> $filters
     */
    public function filter(array $filters): void {
        foreach($filters as $filter) {
            if($filter->isValueSet()) {
                if($filter->getConditionCallback() !== null) {
                    $value = $filter->getValue();

                    if(is_array($value)) {
                        $value = ArrayHash::from($filter->getValue());
                    }

                    ($filter->getConditionCallback())($this->getDataSource(), $value);
                } else {
                    if($filter instanceof FilterText) {
                        $this->applyFilterText($filter);
                    } elseif($filter instanceof FilterMultiSelect) {
                        $this->applyFilterMultiSelect($filter);
                    } elseif($filter instanceof FilterSelect) {
                        $this->applyFilterSelect($filter);
                    } elseif($filter instanceof FilterDate) {
                        $this->applyFilterDate($filter);
                    } elseif($filter instanceof FilterDateRange) {
                        $this->applyFilterDateRange($filter);
                    } elseif($filter instanceof FilterRange) {
                        $this->applyFilterRange($filter);
                    }
                }
            }
        }
    }


    /**
     * @return mixed
     */
    abstract protected function getDataSource();

    abstract protected function applyFilterDate(FilterDate $filter): void;

    abstract protected function applyFilterDateRange(FilterDateRange $filter): void;

    abstract protected function applyFilterRange(FilterRange $filter): void;

    abstract protected function applyFilterText(FilterText $filter): void;

    abstract protected function applyFilterMultiSelect(FilterMultiSelect $filter): void;

    abstract protected function applyFilterSelect(FilterSelect $filter): void;
}
