<?php

namespace IZON\DataGrid\Column;

use IZON\Admin\MVC\ModuleInfo;
use IZON\DataGrid\DataGrid;
use IZON\DataGrid\Exception\DataGridColumnException;

trait TColumnReplacment {

    /** @var string[] */
    protected $replacment = [];

    /**
     * @return string[]
     */
    public function getReplacment(): array {
        return $this->replacment;
    }

    /**
     * @param string[] $replacment
     */
    public function setReplacment(array $replacment): void {
        $this->replacment = $replacment;
    }

    /**
     * @param mixed $value
     */
    protected function replace($value): ?string {
        return isset($this->replacment[$value]) ? $this->replacment[$value] : $value;
    }

}
