<?php

namespace IZON\DataGrid\Traits;

use IZON\MVC\HttpRequest;

trait TDataGridPaginator {

    /** @var int */
    public $page = 1;

    /** @var int|null */
    public $defaultPerPage = 20;

    /** @var int|null */
    public $perPage = 20;

    /** @var array */
    protected $itemsPerPageList = [20, 30, 40, 50, 'all'];

    public function loadState(HttpRequest $request): void {
        $page = $this->getRequestParam('page', 1);
        $this->setPage(is_numeric($page) ? $page : 1);

        $perPage = $this->getRequestParam('perPage', $this->getDefaultPerPage());
        $this->setPerPage(is_integer($perPage) ? $perPage : PHP_INT_MAX);
    }

    public function getDefaultPerPage(): ?int {
        return $this->defaultPerPage;
    }

    public function setDefaultPerPage(?int $defaultPerPage): void {
        $this->defaultPerPage = $defaultPerPage;
    }

    public function getPage(): int {
        return $this->page;
    }

    public function setPage(int $page): void {
        $this->page = $page;
        $this->getPaginator()->setPage($this->page);
    }

    public function getPerPage(): ?int {
        return $this->perPage;
    }

    public function setPerPage(?int $perPage): void {
        $this->perPage = $perPage;
        $this->getPaginator()->setItemsPerPage($this->perPage);
    }

    /**
     * @return mixed[]
     */
    public function getItemsPerPageList(): array {
        return $this->itemsPerPageList;
    }

    /**
     * @param mixed[] $itemsPerPageList
     */
    public function setItemsPerPageList(array $itemsPerPageList): void {
        $this->itemsPerPageList = $itemsPerPageList;
    }

}
