<?php

namespace IZON\DataGrid\Toolbar;

use function AdminPHPView\getModuleActionURL;

class ToolbarModuleLink extends AToolbar {

    /** @var string */
    protected $method;

    /** @var array */
    protected $params;

    public function __construct(string $key, ?string $name, string $method, array $params = []) {
        parent::__construct($key, $name);

        $this->method = $method;
        $this->params = $params;
    }

    public function render(): string {
        $link = getModuleActionURL(
            $this->module->getControllerId(),
            $this->method,
            $this->params,
            $this->module->getIdentifier()
        );
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a class="btn btn--small btn--mint" href="%s"%s>%s</a>', $link, $target, $this->renderName());
    }

}
