<?php

namespace IZON\DataGrid\GroupAction;

class GroupActionExport extends AGroupAction {

    public function __construct(string $key, ?string $name, ?callable $callback = null) {
        if($callback === null) {
            $callback = [$this, 'defaultCallback'];
        }

        parent::__construct($key, $name, $callback);
    }

    public function render(): string {
        return sprintf(
            '<span class="btn btn--small btn--mint js-datagrid-group-action js-datagrid-group-action-export" title="Pokud nevyberete záznamy, vyexportují se všechny vyfiltrované záznamy" style="margin: 0px 2.5px;" data-datagrid-group-action="%s">%s</span>',
            $this->key,
            $this->renderName()
        );
    }

    public function defaultCallback(array $items): void {
        $fileName = sprintf('export-%s.csv', date('YmdHis'));

        header('Pragma: public');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Content-Description: File Transfer');
        header('Content-Type: text/csv');
        header(sprintf('Content-Disposition: attachment; filename=%s;', $fileName));
        header('Content-Transfer-Encoding: binary');

        //open file pointer to standard output
        $fp = fopen('php://output', 'w');

        //add BOM to fix UTF-8 in Excel
        fputs($fp, $bom = (chr(0xEF).chr(0xBB).chr(0xBF)));
        if($fp) {
            $dataGrid = $this->getDataGrid();

            $header = [];
            foreach($dataGrid->getColumns() as $column) {
                $header[] = $column->getName();
            }
            fputcsv($fp, $header, ";");

            foreach($items as $item) {
                $data = [];
                foreach($dataGrid->getColumns() as $column) {
                    $data[] = strip_tags($column->getValue($item));
                }
                fputcsv($fp, $data, ";");
            }
        }

        fclose($fp);
        exit;
    }
}
