<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Action\AAction;
use IZON\DataGrid\Action\ActionLink;
use IZON\DataGrid\Action\ActionModuleLink;
use IZON\DataGrid\Exception\DataGridColumnExistException;

trait TDataGridActions {

    /** @var AAction[] */
    protected $actions = [];

    # GETTERS

    /**
     * @return AAction[]
     */
    public function getActions(): array {
        return $this->actions;
    }

    # SETTERS

    /**
     * @return mixed
     */
    protected function addAction(string $key, AAction $action) {
        if(isset($this->actions[$key])) {
            throw new DataGridColumnExistException($key);
        }

        $action->setModule($this->module);
        $action->setDataGrid($this);

        $this->actions[$key] = $action;
        return $action;
    }

    // ACTIONS

    public function addActionModuleLink(
        string  $key,
        ?string $name,
        string  $method,
        array   $params = [],
        ?string $controllerId = null
    ): ActionModuleLink {
        $action = new ActionModuleLink($key, $name, $method, $params, $controllerId);
        return $this->addAction($key, $action);
    }

    public function addActionLink(
        string  $key,
        ?string $name,
        string  $controllerId,
        array   $params = [],
        ?string $method = null,
        ?string $locale = null,
        ?string $domainUid = null,
        bool    $domainForce = false
    ): ActionLink {
        $action = new ActionLink(
            $key,
            $name,
            $controllerId,
            $params,
            $method,
            $locale,
            $domainUid,
            $domainForce
        );
        return $this->addAction($key, $action);
    }
}
