<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Exception\DataGridColumnException;
use IZON\DataGrid\GroupAction\AGroupAction;
use IZON\DataGrid\GroupAction\GroupActionExport;

trait TDataGridSortAble {

    /** @var bool */
    protected $sortAble = false;

    /** @var bool */
    protected $property = 'position';

    /** @var callable|null */
    protected $callbackSortAble = null;

    public function processSortAble(): void {
        $sortAbleData = $this->getRequestParam('sortable-data');

        if($sortAbleData === null) {
            return;
        }

        $e_data = explode(';', $sortAbleData);
        if(count($e_data) !== 3) {
            return;
        }

        if($this->callbackSortAble === null) {
            $this->callbackSortAble = [$this, 'defaultCallbackSortAble'];
        }

        list($itemId, $prevId, $nextId) = array_map(
            function($item) {
                return empty($item) ? null : intval($item);
            },
            $e_data
        );


        $item = (clone $this->getDatasource())->filterOne(['id' => $itemId])->getData()[0];
        $prev = $prevId === null ? null : (clone $this->getDatasource())->filterOne(['id' => $prevId])->getData()[0];
        $next = $nextId === null ? null : (clone $this->getDatasource())->filterOne(['id' => $nextId])->getData()[0];

        $callback = $this->getCallbackSortAble();
        $callback($item, $prev, $next);
    }

    # GETTER

    public function isSortAble(): bool {
        return $this->sortAble;
    }

    public function isProperty() {
        return $this->property;
    }

    public function getCallbackSortAble(): ?callable {
        return $this->callbackSortAble;
    }

    # SETTER

    public function setSortAble(bool $sortAble = true): void {
        $this->sortAble = $sortAble;
    }

    public function setProperty($property): void {
        $this->property = $property;
    }

    public function setCallbackSortAble(?callable $callbackSortAble = null): void {
        $this->callbackSortAble = $callbackSortAble;
    }

    # SPECIFIC

    public function defaultCallbackSortAble($current, $prev, $next): void {
        $fncGetPosition = function($object): int {
            $methodGet = sprintf('get%s', $this->property);
            $methodIs = sprintf('is%s', $this->property);

            if(is_array($object) && isset($item[$this->property])) {
                $value = $object[$this->property];
            } elseif(is_object($object) && method_exists($object, $methodGet)) {
                $value = $object->$methodGet();
            } elseif(is_object($object) && method_exists($object, $methodIs)) {
                $value = $object->$methodIs();
            } else {
                throw new DataGridColumnException($object, $this->property);
            }

            return intval($value);
        };

        if($prev !== null) {
            $currentPosition = $fncGetPosition($prev) + 1;
        } elseif($next !== null) {
            $currentPosition = $fncGetPosition($next) - 1;
        } else {
            $currentPosition = 1;
        }

        if($prev !== null) {
            $prevPosition = $fncGetPosition($prev);
        } else {
            $prevPosition = null;
        }

        if($next !== null) {
            $nextPosition = $fncGetPosition($next);
        } else {
            $nextPosition = null;
        }

        $this->getDatasource()->updatePosition(
            $this->property,
            $current,
            $currentPosition,
            $prevPosition,
            $nextPosition
        );
    }

}
