<?php

namespace IZON\DataGrid\GroupAction;

class GroupActionSelect extends AGroupAction {

    /** @var array */
    protected $options;

    public function __construct(string $key, ?string $name, array $options, ?callable $callback = null) {
        parent::__construct($key, $name, $callback);

        $this->options = $options;
    }

    public function render(): string {

        $options = ['<option value="">--</option>'];
        $multiSelects = [];
        foreach($this->options as $key => $value) {
            if(is_array($value)) {
                $options[] = sprintf(
                    '<option value="%s" class="js-datagrid-group-action-select-options">%s</option>',
                    $key,
                    $value[AGroupAction::PREFIX_GROUP_ACTION_NAME]
                );
                unset($value[AGroupAction::PREFIX_GROUP_ACTION_NAME]);

                $groupActionOptions = ['<option value="">--</option>'];
                foreach($value as $_key => $_value) {
                    $groupActionOptions[] = sprintf('<option value="%s">%s</option>', $_key, $_value);
                }

                $multiSelects[] = sprintf(
                    '<select name="group_action_select_multi[%s]" class="datagrid-paginator-item" style="margin-left: 2.5px; display: none;">%s</select>',
                    $key,
                    implode('', $groupActionOptions)
                );
            } else {
                $options[] = sprintf('<option value="%s">%s</option>', $key, $value);
            }
        }

        $select = sprintf('<select name="group_action_select" class="datagrid-paginator-item">%s</select>', implode('', $options));

        $btn = sprintf(
            '<span class="btn btn--small btn--mint js-datagrid-group-action js-datagrid-group-action-select" style="margin: 0px 2.5px;" data-datagrid-group-action="%s">%s %s</span>',
            $this->key,
            '<svg class="spinner" viewBox="0 0 50 50"><circle class="path" cx="25" cy="25" r="20" fill="none" stroke-width="5"></circle></svg>',
            $this->renderName()
        );

        return $select.implode('', $multiSelects).$btn;
    }

}
