<?php

declare(strict_types=1);

namespace IZON\DataGrid\Filter;

use IZON\Forms\Form;

class FilterSelect extends OneColumnFilter {

    /** @var string */
    protected $type = 'select';

    /** @var array */
    protected $options;

    /** @var string */
    protected $prompt = '--';

    /** @var bool */
    protected $usePrompt = true;

    public function __construct(
        string $key,
        string $name,
        array $options,
        string $column,
        string $prompt,
        bool $usePrompt
    ) {
        parent::__construct($key, $name, $column);

        $this->options = $options;
        $this->prompt = $prompt;
        $this->usePrompt = $usePrompt;
    }

    public function addToFormContainer(Form $form): void {
        $this->baseField = $form->addSelectField($this->key, $this->name);
        $this->baseField->setNullOnEmpty(true);
        $this->baseField->setOptions($this->options);

        if($this->usePrompt) {
            $this->baseField->setUnselectedText($this->prompt);
        }
    }

    public function getOptions(): array {
        return $this->options;
    }

    public function getCondition(): array {
        return [$this->column => $this->getValue()];
    }

}
