<?php

namespace IZON\DataGrid\GroupAction;

use IZON\Admin\MVC\ModuleInfo;
use IZON\DataGrid\DataGrid;

abstract class AGroupAction {

    public const PREFIX_GROUP_ACTION_NAME = '__groupActionName__';

    /** @var DataGrid|null */
    protected $dataGrid = null;

    /** @var ModuleInfo */
    protected $module;

    /** @var string */
    protected $key;

    /** @var string|null */
    protected $name;

    /** @var callable|null */
    protected $callback;

    /** @var string|null */
    protected $icon = null;

    public function __construct(string $key, ?string $name, ?callable $callback = null) {
        $this->key = $key;
        $this->name = $name;
        $this->callback = $callback;
    }

    // GETTER

    public function getDataGrid(): DataGrid {
        return $this->dataGrid;
    }

    public function getCallback(): ?callable {
        return $this->callback;
    }

    public function getIcon(): ?string {
        return $this->icon;
    }

    // SETTER

    public function setDataGrid(DataGrid $dataGrid): void {
        if(!$this->dataGrid instanceof DataGrid) {
            $this->dataGrid = $dataGrid;
        }
    }

    public function setModule(ModuleInfo $module): void {
        $this->module = $module;
    }

    public function setCallback(?callable $callback): void {
        $this->callback = $callback;
    }

    public function setIcon(?string $icon): void {
        $this->icon = $icon;
    }

    // RENDER

    public function renderIcon(): ?string {
        if($this->icon === null) {
            return null;
        }

        return sprintf('<i class="%s"></i>', $this->icon);
        //return sprintf('<svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--%s"></use></svg>', $this->icon);
    }

    public function renderName(): string {
        return trim(sprintf('%s %s', $this->renderIcon(), $this->name));
    }

    abstract public function render();

}
