<?php

declare(strict_types=1);

namespace IZON\DataGrid\DataSource;

use IZON\DataGrid\Filter\AFilter;
use IZON\DataGrid\Utils\Sorting;

interface IDataSource {

    /**
     * Get count of data
     */
    public function getCount(): int;

    /**
     * Get the data
     */
    public function getData(): array;

    /**
     * Filter data
     *
     * @param array<AFilter> $filters
     */
    public function filter(array $filters): void;

    /**
     * Filter data - get one row
     *
     * @return static
     */
    public function filterOne(array $condition): self;

    /**
     * Filter data - get one row
     *
     * @return static
     */
    public function filterIn(string $columng, array $inArray): self;

    /**
     * Apply limit and offset on data
     *
     * @return static
     */
    public function limit(int $offset, int $limit): self;

    /**
     * Sort data
     *
     * @return static
     */
    public function sort(Sorting $sorting): self;

    /**
     * update position
     *
     * @return static
     */
    public function updatePosition(string $property, $currentId, int $currentPosition, ?int $prevPosition, ?int $nextPosition): self;

}
