<?php

namespace IZON\DataGrid\Render;

use IZON\DataGrid\DataGrid;

class RenderPaginator implements IRender {

    private static function renderBtn(DataGrid $dataGrid, $page): void {
        $paginator = $dataGrid->getPaginator();

        if($page === $paginator->getPage()) {
            $dataGridParam = $dataGrid->getName('page');
            echo sprintf(
                '<input name="datagrid-page" class="datagrid-reload-input datagrid-paginator-item datagrid-paginator-item-active" data-datagrid-param-name="%s" value="%s" data-link="%s">',
                $dataGridParam,
                $page,
                $dataGrid->createLink()
            );
        } else {
            $classes = [];
            // if($page === $paginator->getPage()) {
            //     $classes[] = 'datagrid-paginator-item-active';
            // }
            $classes = implode(' ', $classes);

            echo sprintf(
                '<a href="%s" class="datagrid-paginator-item datagrid-reload %s">%s</a>',
                $dataGrid->createLink(['page' => $page]),
                $classes,
                $page
            );
        }
    }

    private static function renderItemsPerPage(DataGrid $dataGrid): void {
        ?>
            <div style="float: right">
                <?= __('počet na stránku') ?>
                <select name="datagrid-perPage" class="datagrid-reload datagrid-paginator-item" id="<?= $dataGrid->getName('perPage') ?>">
                    <?php foreach($dataGrid->getItemsPerPageList() as $perPage) {
                        $text = is_string($perPage) ? __($perPage) : $perPage;
                        $selected = '';

                        if($perPage === $dataGrid->getPerPage()
                            || ($perPage === 'all' && $dataGrid->getPerPage() === PHP_INT_MAX)) {
                            $selected = ' selected="selected"';
                        }
                        $link = $dataGrid->createLink(['page' => 1, 'perPage' => $perPage]);

                        echo sprintf(
                            '<option value="%s" data-link="%s"%s>%s</option>',
                            $perPage,
                            $link,
                            $selected,
                            $text
                        );
                    } ?>
                </select>
            </div>
        <?php
    }

    public static function render(DataGrid $dataGrid): void {
        $paginator = $dataGrid->getPaginator();

        $showStart = $paginator->getOffset();
        $showCount = $paginator->getOffset() + $paginator->getLength();
        $totalCount = $paginator->getItemCount();
        ?>
        <div class="datagrid-align-center">
            <span style="float: left; padding-top: 5px;">
                zobrazeno <?= $showStart + 1 ?> - <?= $showCount ?> z <?= $totalCount ?>
            </span>

            <?php
            if($paginator->getPageCount() > 1) {

                self::renderBtn($dataGrid, $paginator->getFirstPage());

                $start = max($paginator->getFirstPage(), $paginator->getPage() - 2);
                $end = min($paginator->getLastPage(), $paginator->getPage() + 2);

                if($start > $paginator->getFirstPage() + 1) {
                    echo '&nbsp;...&nbsp;';
                }

                for($i = $start; $i <= $end; $i++) {
                    if($i > $paginator->getFirstPage() && $i < $paginator->getLastPage()) {
                        self::renderBtn($dataGrid, $i);
                    }
                }

                if($end < $paginator->getLastPage() - 1) {
                    echo '&nbsp;...&nbsp;';
                }

                self::renderBtn($dataGrid, $paginator->getLastPage());
            } else {
                echo '&nbsp;';
            }

            self::renderItemsPerPage($dataGrid);
            ?>
        </div>
        <?php
    }

}

