<?php

declare(strict_types=1);

namespace IZON\DataGrid\Utils;

use IZON\DB\Dao;
use IZON\DB\Paginator\PageContent;
use IZON\DB\Paginator\PaginatorConfig;

class PaginatorDataSource {

    /** @var PaginatorConfig */
    private $config;

    /** @var Dao */
    private $dao;

    /** @var callable */
    private $dataSource;

    public function __construct(PaginatorConfig $config, Dao $dao, callable $dataSource) {
        $this->config = $config;
        $this->dao = $dao;
        $this->dataSource = $dataSource;
    }

    public function paginate(PaginatorConfig $config): PageContent {
        $dataSource = $this->dataSource;

        return $dataSource($config);
    }

    public function getConfig(): PaginatorConfig {
        return $this->config;
    }

    public function getDao(): Dao {
        return $this->dao;
    }

}
