<?php

declare(strict_types=1);

namespace IZON\DataGrid\Filter;

use IZON\Forms\Form;
use IZON\DataGrid\DataGrid;

class FilterText extends AFilter {

    /** @var string */
    protected $type = 'text';

    /** @var bool */
    protected $exact = false;

    /** @var bool */
    protected $splitWordsSearch = true;

    /** @var array|string[] */
    protected $columns;

    /**
     * @param array|string[] $columns
     */
    public function __construct(string $key, string $name, array $columns) {
        parent::__construct($key, $name);

        $this->columns = $columns;
    }

    public function addToFormContainer(Form $form): void {
        $this->baseField = $form->addCharField($this->key, $this->name);
    }

    /**
     * Return array of conditions to put in result [column1 => value, column2 => value]
     *    If more than one column exists in fitler text,
     *    than there is OR clause put betweeen their conditions
     * Or callback in case of custom condition callback
     */
    public function getCondition(): array {
        return array_fill_keys($this->columns, $this->getValue());
    }

    public function isExactSearch(): bool {
        return $this->exact;
    }

    public function setExactSearch(bool $exact = true): self {
        $this->exact = $exact;

        return $this;
    }

    public function setSplitWordsSearch(bool $splitWordsSearch): self {
        $this->splitWordsSearch = $splitWordsSearch;

        return $this;
    }

    public function hasSplitWordsSearch(): bool {
        return $this->splitWordsSearch;
    }
}
