<?php

namespace IZON\DataGrid\Column;


use IZON\Utils\Date;

class ColumnDateTime extends AColumn {

    /** @var string */
    protected $format;

    public function __construct(string $key, string $name, string $format = 'd.m.Y H:i', ?string $column = null) {
        parent::__construct($key, $name, $column);

        $this->format = $format;
    }

    protected function render($item): ?string {
        $datetime = parent::render($item);

        if($datetime instanceof \DateTimeInterface || $datetime instanceof Date) {
            return $datetime->format($this->format);
        }

        return null;
    }
}
