<?php

namespace IZON\DataGrid\Action;


use function PHPView\getControllerURL;

class ActionLink extends AAction {

    /** @var string */
    protected $controllerId;

    /** @var array */
    protected $params;

    /** @var string|null */
    protected $method;

    /** @var string|null */
    protected $locale;

    /** @var string|null */
    protected $domainUid;

    /** @var string|null */
    protected $domainForce;

    public function __construct(
        string $key,
        ?string $name,
        string $controllerId,
        array $params = [],
        ?string $method = null,
        ?string $locale = null,
        ?string $domainUid = null,
        bool $domainForce = false
    ) {
        parent::__construct($key, $name);

        $this->controllerId = $controllerId;
        $this->params = $params;
        $this->method = $method;
        $this->locale = $locale;
        $this->domainUid = $domainUid;
        $this->domainForce = $domainForce;
    }

    public function render($item = null): string {
        $params = [];
        foreach($this->params as $key => $prop) {
            $property = $this->getProperty($item, $prop);
            if($property) {
                $params[$key] = $property;
            }
        }

        $link = getControllerURL(
            $this->controllerId,
            $params,
            $this->method,
            $this->locale,
            $this->domainUid,
            $this->domainForce
        );
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $link, $target, $this->renderName());
    }

}
