<?php

namespace IZON\DataGrid\Traits;

use IZON\DataGrid\Exception\DataGridFilterExistException;
use IZON\DataGrid\Filter\AFilter;
use IZON\DataGrid\Filter\FilterDate;
use IZON\DataGrid\Filter\FilterSelect;
use IZON\DataGrid\Filter\FilterText;
use IZON\DataGrid\Utils\Constant;
use IZON\Forms\Form;

trait TDataGridFilters {

    use TDataGridColumns;

    /** @var Form */
    protected $filterForm;

    /** @var AFilter[] */
    protected $filters = [];

    /** @var mixed[] */
    protected $defaultFilter = [];

    /** @var string */
    protected $renderFilterType = Constant::RENDER_FILTER_IN;

    public function loadFilterState(): void {
        foreach($this->filters as $key => $filter) {
            $part = sprintf('filter-%s', $key);
            $value = $this->getRequestParam($part, null);

            if($value !== null && $value !== '') {
                $filter->setValue($value);
                $this->filterForm->getField($key)->setValue($value);
            } elseif(isset($this->defaultFilter[$part])) {
                $value = $this->defaultFilter[$part];

                $filter->setValue($value);
                $this->filterForm->getField($key)->setValue($value);
            }
        }
    }

    // GETTERS

    /**
     * @return AFilter[]
     */
    public function getFilters(): array {
        return $this->filters;
    }

    public function getRenderFilterType(): string {
        return $this->renderFilterType;
    }

    public function getFilterForm(): Form {
        return $this->filterForm;
    }

    // SETTERS

    /**
     * @param mixed[] $default
     */
    public function setFilterDefaults(array $default): void {
        $this->defaultFilter = [];
        foreach($default as $key => $value) {
            $this->defaultFilter[sprintf('filter-%s', $key)] = $value;
        }
    }

    public function setRenderFilterType(string $renderFilterType = Constant::RENDER_FITLER_OUT): void {
        $this->renderFilterType = $renderFilterType;
    }

    /**
     * @return mixed
     */
    protected function addFilter(string $key, AFilter $filter) {
        if(isset($this->filters[$key])) {
            throw new DataGridFilterExistException($key);
        }

        if(!$this->filterForm instanceof Form) {
            $this->filterForm = new Form();
        }

        $filter->setModule($this->module);
        $filter->setDataGrid($this);

        $filter->addToFormContainer($this->filterForm);
        $this->filters[$key] = $filter;

        return $filter;
    }

    public function addFilterText(string $key, string $name, array $columns = []): FilterText {
        if(empty($columns)) {
            $columns = [$key];
        }

        $filter = new FilterText($key, $name, $columns);
        return $this->addFilter($key, $filter);
    }

    public function addFilterSelect(
        string $key,
        string $name,
        array $options,
        ?string $column = null,
        string $prompt = '--',
        bool $usePrompt = true
    ): FilterSelect {
        return $this->addFilter(
            $key,
            new FilterSelect($key, $name, $options, $column ? $column : $key, $prompt, $usePrompt)
        );
    }

    public function addFilterDate(string $key, string $name, ?string $column = null): FilterDate {
        return $this->addFilter($key, new FilterDate($key, $name, $column ? $column : $key));
    }

}
