<?php

namespace IZON\DataGrid\Action;

use IZON\Admin\MVC\ModuleInfo;
use IZON\DataGrid\DataGrid;
use IZON\DataGrid\Exception\DataGridColumnException;

abstract class AAction {

    /** @var DataGrid|null */
    protected $dataGrid = null;

    /** @var ModuleInfo */
    protected $module;

    /** @var string */
    protected $key;

    /** @var string|null */
    protected $name;

    /** @var boolean */
    protected $targetBlank = false;

    /** @var string|null */
    protected $icon = null;

    public function __construct(string $key, ?string $name) {
        $this->key = $key;
        $this->name = $name;
    }

    // GETTER

    public function getDataGrid(): DataGrid {
        return $this->dataGrid;
    }

    public function isTargetBlank(): bool {
        return $this->targetBlank;
    }

    public function getIcon(): ?string {
        return $this->icon;
    }

    // SETTER

    public function setDataGrid(DataGrid $dataGrid): void {
        if(!$this->dataGrid instanceof DataGrid) {
            $this->dataGrid = $dataGrid;
        }
    }

    public function setTargetBlank(bool $targetBlank = true): self {
        $this->targetBlank = $targetBlank;
        return $this;
    }

    public function setModule(ModuleInfo $module): void {
        $this->module = $module;
    }

    public function setIcon(?string $icon): void {
        $this->icon = $icon;
    }

    // RENDER

    public function renderIcon(): ?string {
        if($this->icon === null) {
            return null;
        }

        return sprintf('<i class="%s"></i>', $this->icon);
        //return sprintf('<svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--%s"></use></svg>', $this->icon);
    }

    public function renderName(): string {
        return trim(sprintf('%s %s', $this->renderIcon(), $this->name));
    }

    abstract public function render($item);

    // PROPERTY

    protected function getProperty($item, string $column, bool $throw = false) {
        $property = ucfirst($column);

        $methodGet = sprintf('get%s', $property);
        $methodIs = sprintf('is%s', $property);

        if(is_array($item) && isset($item[$this->column])) {
            $value = $item[$this->column];
        } elseif(is_object($item) && method_exists($item, $methodGet)) {
            $value = $item->$methodGet();
        } elseif(is_object($item) && method_exists($item, $methodIs)) {
            $value = $item->$methodIs();
        } elseif($throw) {
            throw new DataGridColumnException($item, $column);
        } else {
            return $column;
        }

        return $value;
    }
}
