<?php

declare(strict_types=1);

namespace IZON\DataGrid\Filter;

use IZON\DataGrid\DataGrid;

abstract class OneColumnFilter extends AFilter {

    /** @var string */
    protected $column;

    public function __construct(string $key, string $name, string $column) {
        parent::__construct($key, $name);

        $this->column = $column;
    }

    public function getColumn(): string {
        return $this->column;
    }

    public function getCondition(): array {
        return [$this->column => $this->getValue()];
    }
}
