<?php

namespace IZON\DataGrid\Action;

use function AdminPHPView\getModuleActionURL;

class ActionModuleLink extends AAction {

    /** @var string */
    protected $method;

    /** @var array */
    protected $params;

    /** @var string */
    protected $controllerId;

    public function __construct(
        string  $key,
        ?string $name,
        string  $method,
        array   $params = [],
        ?string $controllerId = null
    ) {
        parent::__construct($key, $name);

        $this->method = $method;
        $this->params = $params;

        $this->controllerId = $controllerId ?? $this->module->getControllerId();
    }

    public function render($item = null): string {
        $params = [];
        foreach($this->params as $key => $prop) {
            $property = $this->getProperty($item, $prop);
            if($property) {
                $params[$key] = $property;
            }
        }

        $link = getModuleActionURL(
            $this->controllerId,
            $this->method,
            $params,
            $this->module->getIdentifier()
        );
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $link, $target, $this->renderName());
    }

}
